import numpy as np

import os
air_hockey_variants = {
    # TODO: add all the variants
    "default": (os.path.join(os.path.dirname(os.path.abspath(__file__)), "air_hockey_configs", "puck_goal.yaml")),
    "hard": (os.path.join(os.path.dirname(os.path.abspath(__file__)), "air_hockey_configs", "puck_goal_hard.yaml")),
    "obstacles": (os.path.join(os.path.dirname(os.path.abspath(__file__)), "air_hockey_configs", "puck_goal_obstacles.yaml")),
}
# self.env_config_path, num_obstaclesgoal_type, self.target_object, self.goal_lims, self.max_reward, self.raw_images

    # TARGET_HALFSIZE = 0.05  # half of side length of block
    # PUCK_RADIUS = 0.025  # radius of goal circle
    # PADDLE_HANDWIDTH = 0.025
    # PADDLE_HALFRADIUS = 0.06
    # PADDLE_HEIGHT = 0.1
    # GRIPPER_BOUNDS = np.array([
    #     [-0.2, 0],  # x
    #     [-0.1, 0.1],  # y
    #     [0, 0.2],  # z
    # ])
    # PADDLE_SPAWN_AREA = np.array([
    #     [-0.2, -0.08],  # x
    #     [-0.1, 0.1],  # y
    # ])
    # TARGET_SPAWN_AREA = np.array([
    #     [0.12, 0.13],  # x
    #     [-0.1, 0.1],  # y
    # ])
    # PUCK_SPAWN_AREA = np.array([
    #     [-0.1, 0.07],  # x
    #     [-0.1, 0.1],  # y
    # ])
    # SPAWN_AREA_SIZE = 0.15
    # OBSTACLE_GRID_RESOLUTION = 5  # side length of obstacle grid
    # OBSTACLE_HEIGHT = 0.1
    # OBSTACLE_HALF_SIDELENGTH = SPAWN_AREA_SIZE / OBSTACLE_GRID_RESOLUTION

def define_object_dicts(env):
    num_obstacles = env.num_blocks
    ranges = {
        "Action": [np.array([-1,-1]).astype(np.float64), np.array([1,1]).astype(np.float64)],
        "Target": [np.array([env.table_x_top, env.table_y_left, -env.length*4, -env.length*4]).astype(np.float64), np.array([env.table_x_bot, env.table_y_right, env.length*4, env.length*4]).astype(np.float64)],
        "Paddle": [np.array([0, env.table_y_left, -env.length*2, -env.length*2]).astype(np.float64), np.array([env.table_x_bot, env.table_y_right, env.length*2, env.length*2]).astype(np.float64)],
        "Goal": [np.array([env.table_x_top, env.table_y_left]).astype(np.float64), np.array([env.table_x_bot, env.table_y_right,]).astype(np.float64)], # even though goals initialized above, uses the top
        "Done": [np.array([0]).astype(np.float64), np.array([1]).astype(np.float64)],
        "Reward": [np.array([-100]).astype(np.float64), np.array([100]).astype(np.float64)]
    }
    if num_obstacles > 0: ranges["Obstacle"] = [np.array([env.table_x_top, env.table_y_left]).astype(np.float64), np.array([env.table_x_bot, env.table_y_right]).astype(np.float64)]

    dynamics = {
        "Action": [np.array([-2,-2]).astype(np.float64), np.array([2,2]).astype(np.float64)],
        "Target": [np.array([-env.length/20, -env.length/20, -env.length*1.7, -env.length*1.7]).astype(np.float64), np.array([env.length/20, env.length/20, env.length*1.7, env.length*1.7]).astype(np.float64)],
        "Paddle": [np.array([-env.length*2, -env.length*2, -env.length*2, -env.length*2]).astype(np.float64), np.array([env.length*2, env.length*2, env.length*2, env.length*2]).astype(np.float64)],
        "Goal": [np.array([-0.1, -0.1]).astype(np.float64), np.array([0.1, 0.1]).astype(np.float64)],
        "Done": [np.array([0]).astype(np.float64), np.array([1]).astype(np.float64)],
        "Reward": [np.array([-100]).astype(np.float64), np.array([100]).astype(np.float64)]
    }
    if num_obstacles > 0: dynamics["Obstacle"] = [np.array([-env.length/16, -env.length/16]).astype(np.float64), np.array([env.length/16, env.length/16]).astype(np.float64)]


    position_masks = {
        "Action": np.array([0,0]),
        "Paddle": np.array([1,1,0,0]),
        "Target": np.array([1,1,0,0]),
        "Goal": np.array([1,1]),
        "Done": np.array([0]),
        "Reward": np.array([0]),
    }
    if num_obstacles > 0: position_masks["Obstacle"] = np.array([1,1])

    instanced = {
        "Action": 1,
        "Target": 1,
        "Paddle": 1,
        # "Obstacle": 20,
        "Goal": 1,
        "Done": 1,
        "Reward": 1
    }
    if num_obstacles > 0: instanced["Obstacle"] = num_obstacles
    return ranges, dynamics, position_masks, instanced